REM  Copyright (c) 1999 by Oracle Corporation 
REM    NAME
REM     PowerPointSolution.sql - APIs to enables Oracle callouts to PowerPoint Automation Server
REM    DESCRIPTION
REM		Demonstrate Oracle Database callouts using the COMCartridge to Microsoft PowerPoint application
REM		Expose a set of calls to
REM		1. Create a PowerPoint presentation
REM		2. Add a new slide to active presentation
REM		3. Set title for active slide
REM		4. Insert text to active slide
REM		5. Save active presentation
REM		6. Save active presentation to a new file
REM		7. Close active presentation
REM		8. Exit PowerPoint
REM
REM    MODIFIED   (MM/DD/YY)
REM     klau	06/15/99 -  Creation
REM
REM

drop package ORDPPT; 
/
CREATE PACKAGE ORDPPT AS

	LayoutBlank			CONSTANT VARCHAR2(2) :=12;
	LayoutChart			CONSTANT VARCHAR2(2) :=8;
	LayoutChartAndText		CONSTANT VARCHAR2(2) :=6;
	LayoutClipartAndText		CONSTANT VARCHAR2(2) :=10;
	LayoutClipArtAndVerticalText	CONSTANT VARCHAR2(2) :=26;
	LayoutFourObjects		CONSTANT VARCHAR2(2) :=24;
	LayoutLargeObject		CONSTANT VARCHAR2(2) :=15;
	LayoutMediaClipAndText		CONSTANT VARCHAR2(2) :=18;
	LayoutMixed			CONSTANT VARCHAR2(2) :=-2;
	LayoutObject			CONSTANT VARCHAR2(2) :=16;
	LayoutObjectAndText		CONSTANT VARCHAR2(2) :=14;
	LayoutObjectOverText		CONSTANT VARCHAR2(2) :=19;
	LayoutOrgchart			CONSTANT VARCHAR2(2) :=7;
	LayoutTable			CONSTANT VARCHAR2(2) :=4;
	LayoutText			CONSTANT VARCHAR2(2) :=2;
	LayoutTextAndChart		CONSTANT VARCHAR2(2) :=5;
	LayoutTextAndClipart		CONSTANT VARCHAR2(2) :=9;
	LayoutTextAndMediaClip		CONSTANT VARCHAR2(2) :=17;
	LayoutTextAndObject		CONSTANT VARCHAR2(2) :=13;
	LayoutTextAndTwoObjects		CONSTANT VARCHAR2(2) :=21;
	LayoutTextOverObject		CONSTANT VARCHAR2(2) :=20;
	LayoutTitle			CONSTANT VARCHAR2(2) :=1;
	LayoutTitleOnly			CONSTANT VARCHAR2(2) :=11;
	LayoutTwoColumnText		CONSTANT VARCHAR2(2) :=3;
	LayoutTwoObjectsAndText		CONSTANT VARCHAR2(2) :=22;
	LayoutTwoObjectsOverText 	CONSTANT VARCHAR2(2) :=23;
	LayoutVerticalText		CONSTANT VARCHAR2(2) :=25;
	LayoutVerticalTitleAndText	CONSTANT VARCHAR2(2) :=27;
	LayoutVertTtleAndTextOverChart	CONSTANT VARCHAR2(2) :=28;

	FUNCTION CreatePresentation (servername IN varchar2) RETURN binary_integer;
	FUNCTION AddSlide (layout IN binary_integer) RETURN binary_integer;
	FUNCTION SetTitle (title IN varchar2) RETURN binary_integer;
	FUNCTION InsertText (orientation IN binary_integer,
		left IN binary_integer, top IN binary_integer,
		width IN binary_integer, height IN binary_integer,
		text IN VARCHAR2) RETURN binary_integer;
	FUNCTION PresentationSave RETURN binary_integer;
	FUNCTION PresentationSaveAs (filename IN varchar2) RETURN binary_integer;
	FUNCTION PresentationClose RETURN binary_integer;
	FUNCTION Exit RETURN binary_integer;
	
END ORDPPT;
/

CREATE PACKAGE BODY ORDPPT AS

	i		binary_integer;
	app		binary_integer:=-1;
	presentation	binary_integer:=-1;
	slide		binary_integer:=-1;

PROCEDURE CheckError (message IN VARCHAR2) IS
	error_src		varchar2(255);
	error_description	varchar2(255);
	error_helpfile		varchar2(255);
	error_helpID		binary_integer;
BEGIN
	IF (i!=0) THEN
		ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
		dbms_output.put_line(message);
		dbms_output.put_line(error_src);
		dbms_output.put_line(error_description);
		dbms_output.put_line(error_helpfile);
	END IF;
END CheckError;

FUNCTION CreatePresentation (servername IN varchar2 DEFAULT '') RETURN binary_integer IS
	dummy		binary_integer;	
	pres		binary_integer:=-1;
BEGIN
	-- Create PowerPoint Application
	dbms_output.put_line('Creating PowerPoint Application...');
	i:=ORDCOM.CreateObject('PowerPoint.Application', 0, servername, app);
	CheckError('Create PowerPoint Application');
	
	-- Get Presentation
	dbms_output.put_line('Getting Presentation...');
	i:=ORDCOM.GetProperty(app, 'Presentations',0, pres);
	CheckError('Get Presentation');

	-- Add Presentation
	dbms_output.put_line('Adding Presentation...');
	i:=ORDCOM.Invoke(pres, 'Add',0, dummy);
	CheckError('Add Presentation');

	-- Get Active Presentation
	dbms_output.put_line('Getting Active Presentation...');
	i:=ORDCOM.GetProperty(app, 'ActivePresentation',0, presentation);
	CheckError('Get Active Presentation');
	
	return i;
END CreatePresentation;

FUNCTION AddSlide (layout IN binary_integer) RETURN binary_integer IS
	slides		binary_integer:=-1;
BEGIN
	-- Getting Slides
	dbms_output.put_line('Getting Slides...');
	i:=ORDCOM.GetProperty(presentation, 'Slides',0, slides);
	CheckError('Get Slides');

	-- Adding Slide
	dbms_output.put_line('Adding Slide...');
	ORDCOM.InitArg();
	ORDCOM.setArg('1','I2');
	ORDCOM.setArg(layout,'I2');
	i:=ORDCOM.Invoke(slides, 'Add',2, slide);
	CheckError('Add Slide');
	
	return i;
END AddSlide;

FUNCTION SetTitle (title IN varchar2) RETURN binary_integer IS
	shapes		binary_integer:=-1;
	ttl		binary_integer:=-1;
	textframe	binary_integer:=-1;
	textrange	binary_integer:=-1;
BEGIN
	dbms_output.put_line('Getting Shapes...');
	i:=ORDCOM.GetProperty(slide, 'shapes', 0, shapes);
	CheckError('Get Shapes');
	
	dbms_output.put_line('Getting Title...');
	i:=ORDCOM.GetProperty(shapes, 'title', 0, ttl);
	CheckError('Get Title');
	
	dbms_output.put_line('Getting Text Frame...');
	i:=ORDCOM.GetProperty(ttl, 'textframe', 0, textframe);
	CheckError('Get TextFrame');
	
	dbms_output.put_line('Getting Text Range...');
	i:=ORDCOM.GetProperty(textframe, 'textrange', 0, textrange);
	CheckError('Get Text Range');
	
	dbms_output.put_line('Setting Title Text...');
	i:=ORDCOM.SetProperty(textrange, 'text', title, 'BSTR');
	CheckError('Set Title Text');
	
	return i;
END SetTitle;

FUNCTION InsertText (orientation IN binary_integer,
		left IN binary_integer, top IN binary_integer,
		width IN binary_integer, height IN binary_integer,
		text IN VARCHAR2)
RETURN binary_integer IS
	shapes		binary_integer:=-1;
	textbox		binary_integer:=-1;
	textframe	binary_integer:=-1;
	textrange	binary_integer:=-1;
BEGIN
	dbms_output.put_line('Getting Shapes...');
	i:=ORDCOM.GetProperty(slide, 'shapes', 0, shapes);
	CheckError('Get Shapes');
	
	ORDCOM.InitArg();
	ORDCOM.setArg(orientation,'I2');
	ORDCOM.setArg(left,'I2');
	ORDCOM.setArg(top,'I2');
	ORDCOM.setArg(width,'I2');
	ORDCOM.setArg(height,'I2');
	dbms_output.put_line('Adding Text Box...');
	i:=ORDCOM.Invoke(shapes,'AddTextBox', 5, textbox);
	CheckError('Add Text Box');
	
	dbms_output.put_line('Getting Text Box Text Frame...');
	i:=ORDCOM.GetProperty(textbox, 'textframe', 0, textframe);
	CheckError('Get Text Box Text Frame');
	
	dbms_output.put_line('Getting Text Box Text Range...');
	i:=ORDCOM.GetProperty(textframe, 'textrange', 0, textrange);
	CheckError('Get Text Box Text Range');
	
	dbms_output.put_line('Setting Text Box Text...');
	i:=ORDCOM.SetProperty(textrange, 'text', text, 'BSTR');
	CheckError('Set Text Box Text');

	return i;
END InsertText;

FUNCTION PresentationSave RETURN binary_integer IS
	dummy		binary_integer;	
BEGIN
	dbms_output.put_line('Saving Presentation...');
	i:=ORDCOM.Invoke(presentation, 'Save', 0, dummy);
	CheckError('Save Presentation');

	return i;
END PresentationSave;

FUNCTION PresentationSaveAs (filename IN varchar2) RETURN binary_integer IS
	dummy		binary_integer;	
BEGIN
	dbms_output.put_line('Saving Presentation...');
	ORDCOM.InitArg();
	ORDCOM.setArg(filename,'BSTR');
	i:=ORDCOM.Invoke(presentation, 'SaveAs', 1, dummy);
	CheckError('Save Presentation');

	return i;
END PresentationSaveAs;

FUNCTION PresentationClose RETURN binary_integer IS
	dummy		binary_integer;	
BEGIN
	dbms_output.put_line('Closing Presentation...');
	i:=ORDCOM.Invoke(presentation, 'Close', 0, dummy);
	CheckError('Close Presentation');

	return i;
END PresentationClose;

FUNCTION Exit RETURN binary_integer IS
	dummy		binary_integer;	
BEGIN
	dbms_output.put_line('Exiting PowerPoint...');
	i:=ORDCOM.Invoke(app, 'Quit',0, dummy);
	CheckError('Exit PowerPoint');
	
	dbms_output.put_line('Destroy Application...');
	i:=ORDCOM.DestroyObject(app);
	CheckError('Destory Application');

	return i;
END Exit;

END ORDPPT;